---
title: Lecture 35：微分方程的基本概念
tags:
  - 数学
  - 微分方程
categories: 
date: 2024-02-01
---
---
## 本章常考题型与典型例题
**考试内容**
+ (一)常微分方程的基本概念
+ (二)一阶微分方程
+ (三)可降阶的高阶方程 (数三不要求)
+ (四)高阶线性微分方程
+ (五)差分方程 (仅数三要求)

**常考题型**
+ 题型一：微分方程求解
+ 题型二：综合题
+ 题型三：应用题

## 1.1 什么是微分方程
##### **定义**： #微分方程
> <font color="#ccc1d9">描述：</font>含有未知函数**导数**或者**微分**的方程，就称之为微分方程；
> 微分方程是一种用来描述**函数与其导数之间关系**的数学方程。
> 1. 它的解不是数，而是**符合方程关系的函数** 
> 2. 微分方程的起源约在十七世纪末，为了解决自然科学发展中遇到物理及天文学问题而产生；
> 3. 一般的表示未知函数、未知函数的导数与自变量之间的关系的方程叫做微分方程；
> 4. 未知函数是一元函数的叫**常微分方程**，未知函数是多元函数的叫做**偏微分方程**；
> 5. 微分方程是伴随着微积分学一起发展起来的；
> 6. 微分方程包含未知函数及其导数的方程，未知函数导数的最高阶数称为该微分方程的阶； 

**基础概念**
+ 微分方程：
	+ 概念：
		+ 含有未知函数导数或微分的方程
	+ 举例： 
		+ $y^{\prime}=y+x,y^{\prime\prime}+y^{3}=x,y^{\prime\prime}=e^{x}$
+ 阶：
	+ 概念：
		+ 含有未知函数**导数**的**最高阶数**；
	+ 举例： 
		+ 微分方程为 n 阶时：$F(x,y,y^{\prime},y^{(n)})=0$
+ 解：
	+ 概念：
		+ 若将函数代入微分方程, 使方程成为恒等式, 则该函数称为微分方程的解。 
		+ $\begin{gathered}\text{设：}y=y (x)\text{在区间 I 上连续且有} \text{直到 }n\text{ 阶的导数, 使 }F[x,y (x), y^{\prime}(x),\cdotp\cdotp\cdotp, y^{(n)}(x)]\equiv 0,\text{则称 }y=y (x)\text{为该微分方程在区间 }I\text{ 上的一个解}. \end{gathered}$
	+ 举例： 
		+ 若当前的微分方程为 $y^{\prime\prime}=e^{x}$
		+ 则当前方程的解为：
			+ 1. 此方程 $y=e^{x}$ 为微分方程的解；
			+ 2. 此方程 $y=e^{x}+c_{1}x+c_{2}$ 也为微分方程的解；
+ 通解：
	+ 概念：
		+ 如果微分方程的解**含有任意的常数**，并且含任意独立的（无法合并）常数的**个数等于微分方程的阶**，则称之为方程的通解； 
		+ 即：通解代表着解的集合，独立常数的个数需要等于微分方程的阶数；
	+ 举例：
		+ 如果有二阶导数的微分方程
		+ $y^{\prime\prime}=3 ; y^{\prime}=3x+c_{1}$
		+ 此时，y 的函数必须要有两个常数：$y=\frac{3}{2}x^{2}+C_{1}x+C_{2}$
+ 特解：
	+ 概念：
		+ 不含有任意常数的微分方程的解，称之为微分方程的特解；
	+ 补充：
		+ 通解里面定住任意常数；
		+ 想求特解，需要先求出通解。然后在给定的约束条件（初始条件）下，解出对应的特解；
+ 初始条件：
	+ 确定定解的条件；
+ 积分曲线：
	+ 解对应的曲线，称之为微分方程的积分曲线；

**微分方程的作用**
+ 图示：
	+ ![[Pasted image 20240422161204.png]]

##### **定义**： #一阶方程
> <font color="#ccc1d9">描述：</font>一阶方程的一般形式：$y^\prime=f(x,y)$

##### **定义**： #二阶以及高阶方程
> <font color="#ccc1d9">描述：</font>
> 1. 二阶微分方程：表达式中的最高阶导数是二阶导数；
> 2. 高阶微分方程：包含三阶导数四阶导数或更高阶导数的方程；
> 	二阶微分方程一般形式：$$y^{\prime}=f(x,y,y^{\prime})$$

##### **定义**： #常微分方程
> <font color="#ccc1d9">描述：</font>函数的自变量只有一个；

**解释**
+ 引入：
	+ 物理学上：最常用的常微分方式中的变量，就是时间；
+ 举例：研究小球往上抛出去后，其位置变化；
	+ 当前的微分方程：二阶导数
		+ 小球的重力加速度
			+ $$\ddot{y}(t)=-g$$
	+ 知道**一阶导数**：
		+ 知道向下的分量为重力加速度 $-g$，因此 $\ddot{y}(t)=-g$，还可以将其和速度的关系描述出来：$$\frac{d(-gt+v_0)}{dt}(t)=-g$$
		+ 但只知道这个还无法确定原函数，还需要为其增加初始状态，来进行约束；
	+ 加上**初始条件 1**：
		+ 在 $v_0$ 的速度基础上，进行的向下 g 作用：$\dot{y}(t)=-gt+v_0$
		+ 问题：还是不知道原函数 $$\frac{d(????)}{dt}(t)=-gt+v_0$$
	+ 知道**原函数**：
		+ $$\frac{d(-(1/2)gt^{2}+v_{0}t)}{dt}(t)=-gt+v_{0}$$
	+ 加上**初始条件 2**：
		+ 当物体的初始的位置为 $y_0$ 时，且其关系为：$$\frac{d(-(1/2)gt^{2}+v_{0}t+y_{0})}{dt}(t)=-gt+v_{0}$$
	+ 得到**微分方程的解**：
		+ $y(t)=-(1/2)gt^2+v_0t+y_0$


##### **定义**： #偏微分方程
> <font color="#ccc1d9">描述：</font>函数的自变量有多个；
> 基于偏导数写出来的微分方程，因此被称之为偏微分方程；

**解释**
+ 偏导数：
	+ 以为当前有两个变量，它们各自的导数式，为偏导数：
	+ $$\frac{dT}{dt}(x,t)\quad\frac{dT}{dx}(x,t)$$
	+ 为了和常微分方程中的求导数的 d 微分进行区分，在这使用新的符号：
	+ $$\frac{\partial T}{\partial t}(x,t)\quad\frac{\partial T}{\partial x}(x,t)$$
+ 举例：热传导方程
	+ 公式：
		+ $\frac{\partial T}{\partial t}=\alpha\nabla^2T$
	+ 对应的偏微分方程：
		+ 因为是基于偏导数写出来的微分方程，因此被称之为偏微分方程；
		+ $$\frac{\partial T}{\partial t}(x,t)=\alpha\cdot\frac{\partial^2T}{\partial x^2}(x,t)$$
	+ 图示：
		+ ![[Pasted image 20240422162747.png]]

##### **定义**： #偏导数
> <font color="#ccc1d9">描述：</font>如果是对 $z=f(x,y)$ 函数，会有两个偏导数的定义：
> 1. 对 X 的偏导数：对 X 偏导时，Y 固定在 $y_0$ 处（对 x 没有任何影响），$x在x。处有\Delta x$ 的增量，此时只有 x 一个变量，此时称： 
>     $\lim_{\Delta x\to0}\frac{f\left(x_{0}+\Delta x,y_{0}\right)-f\left(x_{0},y_{0}\right)}{\Delta x}$ 为对 X 的偏导数；
>     记作：$\left.\frac{\partial z}{\partial x}\right|_{(x_{0},y_{0})},\left.\frac{\partial f}{\partial x}\right|_{(x_{0},y_{0})},z_{_z}(x_{0},y_{0})或$ $f_{x}(x_{0},y_{0})$
> 2. 对 Y 的偏导数：和 X 同理，
>     $lim_{\Delta y\to0}\frac{f(x_{0},y_{0}+\Delta y)-f(x_{0},y_{0})}{\Delta y}$；
>     记为：$\left.\text{}\frac{\partial z}{\partial y}\right|_{(x_{0},y_{0})},\left.\frac{\partial f}{\partial y}\right|_{(x_{0},y_{0})},z_{y}(x_{0},y_{0})\text{或}f_{y}(x_{0},y_{0}).$

**方法**：如何求对 x 或者 y 的偏导
+ 当 $z=f(x,y)$ 时，把 y 或者 x 视为常数，直接对 x 或者 y 求导；
+ 例：$z=x^{2}+3xy+y^{2}在(1.2)处$ 的偏导数；
	+ 第一步：求出偏导后的函数
		+ 对 x 求偏导：$\frac{\partial z}{\partial x}=2x+3y$
		+ 对 y 求偏导：$$\frac{\partial z}{\partial y}=3x+2y$$
	+ 第二步：将 $(1.2)$ 点带入对 x 求偏导或者对 y 求偏导后的函数： 2 x+3 y 或者 3 x+2 y，即可得到结果

**二元函数偏导**
+ 一元函数中
	+ 可导 -> 连续
	+ 可导是一个很强的条件
+ 二元函数中
	+ 二元函数对 x 的偏导存在的前提 <- 在 y= $y_0$ 这一条直线上，它是连续的；
	+ 对二元函数来说，偏导存在，在 $(x_0,y_0)$ 未必连续；

## 1.2 可分离变量的微分方程
##### **定义**： #可分离变量的方程
> <font color="#ccc1d9">描述：</font> 
> 形式：$$y^{\prime}=f(x)g(y)$$
> 解释：$\frac{dy}{dx}=f(x)g(y)$ `->` $\frac{dy}{g(y)}=f(x)dx$ 可以把 $g(y)$ 和 $dy$ 、$f(x)$ 个 $dx$ 分离到等式的两边 `->` 可分离变量的微分方程；
> 可分离变量的解：两边积分 $$\int\frac{dy}{g(y)}=\int f(x)dx$$

**例题**：$\text{微分方程 }y^{\prime}=\frac{y(1-x)}x\text{ 的通解是}$
+ 分析
+ 解析
	+ $$\frac{dy}{dx}=\frac{y(y-x)}{x}\quad\quad\quad\quad\\\int\frac{dy}{y}=\int\frac{1-x}{x}dx\quad\quad\quad\quad\\\ln|y|=\ln|x|-x+c_{1}$$
	+ $$|y|=e^{2|x|-x+c_{1}}=e^{c_{1}}|x|e^{-x}\\y=\pm e^{2}xe^{-x}=Cxe^{-x}$$
+ 题型：#

**例题**：$\frac{dy}{dx}=2xy$
+ 分析
+ 解析
	+ 求积分
		+ $\int\frac{dy}{y}=fxdx$
	+ 得到：
		+ $\ln|y|=x^{2}+c$
	+ 所以：
		+ $|y|=e^{x^{2}+c}$
	+ 最终：
		+ $y=\pm e^{x^{2}}；e^{c^{2}}=\pm C_{1}e^{x^{2}}$
+ 题型： #可分离变量

## 1.3 齐次方程
##### **定义**： #齐次方程
> <font color="#ccc1d9">描述：</font>简化后的方程中**所有非零项的指数相等**：$$\frac{dy}{dx}=\varphi(\frac{y}{x})$$
 
**解释**
+ 概念：
	+ 右端是关于 xy 的二元函数，但可以写成 $\frac{y}{x}$ 的二元函数；
+ 齐次：
	+ 右端作为一个二元函数，是一个**零次、齐次函数**；
	+ 即：dy 比 dx 是函数，且**关于 x，y 次数相等**

**方法**：三板斧
+ 第零步：整理成齐次方程的形式，左边只有 $\frac{dy}{dx}$，即 $\frac{dy}{dx}=\varphi(\frac{y}{x})$；
+ 第一步：写下 $u=\frac{y}{x}$
+ 第二步：因为 $y=xu$，所以对 y 求导后，可以得到 $\frac{dy}{dx}=u+x\frac{du}{dx}$ ，即得到了 $y^{\prime}=\frac{dy}{dx}=u+x\frac{du}{dx}=u+xu^{\prime}$ 的表达式；
+ 第三步：带会原函数，得到 $u+x\frac{du}{dx}=\varphi(\frac{y}{x})$，这个方程是可分离变量；
	+ 即：把其变成可分离变量，求解；

**例题**：$\text{求微分方程 }x^2y^{\prime}+xy=y^2\text{ 满足初始条件}y(1)=1的特解$
+ 分析
+ 解析
	+ 原方程为齐次方程 $y^{\prime}=(\frac{y}{x})^{2}-\frac{y}{x}$
	+ $\text{令 }u=\frac yx\text{,则}$
	+ $xu^{\prime}+u=u^2-u,\quad xu^{\prime}=u^2-2u.$ 
	+ 此时可以分离变量：$\frac{du}{u^{2}-2u}=\frac1xdx$ 
	+ $\frac12[\ln|u-2|-\ln|u|]=\ln|x|+C_1,\frac{u-2}u=Cx^2$
	+ $\frac{y-2x}y=Cx^2$
	+ 由 $y(1)=1$,得 $C=-1$ ,即得所求的特解为$$\frac{y-2x}y=-x^2,\quad\text{即 }y=\frac{2x}{1+x^2}$$
+ 题型：#

**例题**：$y^{2}+x^{2}\frac{dy}{dx}=xy\frac{dy}{dx}$
+ 分析
	+ 注意：
	+ 1. 先对函数处理，处理成函数满足 y/x 的形式；
	+ 2. 如何判断是否是齐次方程 -> x 和 y 的次数比较对称；
+ 解析
	+ 首先整理一下：
		+ $\frac{dy}{dx}=\frac{y^{2}}{xy-x^{2}}$
	+ 然后分子分母都除以 x 的平方；
		+ $\frac{\left(\frac{y}{x}\right)^{2}}{\frac{y}{x}-1}$
	+ 然后使用三板斧解题
		+ $x\frac{du}{dx}=\frac{u^{2}}{u-1}-u$
	+ 然后
		+ $\frac{u-1}{u}du=\frac{dx}{x}$
+ 题型： #齐次方程 

## 1.4 常考题型
### 题型： #微分方程求解
#### PART 1：解题方法
**核心**：判断类型，选择方法
+ 概念：
	+ 如果是求特解的题目，先求通解；
	+ 求通解之前，先判断当前微分方程的类型；

**总结**：微分方程类型判断方法
+ 方法：
	+ 1. 判断类型，并且判断类型时一般是导数的形式（即非微分的形式，没有 $dy$、$dx$ 这些）
	+ 2. 如果什么形式都判断不出来 `->` 
		+ 方法一： $x、y$ 两者**对调**；
		+ 方法二：变量代换；
	+ 3. 确定阶数：确定当且是多少阶；
	+ 4. 凑微分核心方法：分组凑微分 `->` 单独好凑的，单独来凑微分。不好凑的，几个式子放在一起；

**总结**：常见形式
+ 一元方程：
	+ 一阶方程： 
		+ （A）齐次方程：
			+ 形式：$$\frac{dy}{dx}=\varphi(\frac{y}{x})$$
			+ 方法：令 $u=\frac yx$，变量代换、带进去整理 `->` 转变成可分离变量；
		+ （B）线性方程：
			+ 形式：$$y^{\prime}+P(x)y=Q(x)$$
			+ 方法：整理成标准形式，然后带通解公式 $$y=e^{-\int p(x)dx}\left[\int Q(x)e^{\int p(x)dx}dx+C\right]$$ `->` [[Lecture 36：一阶线性微分方程]]
		+ （C）伯努利方程：
			+ 形式：$$y^{\prime}+p (x) y=Q (x) y^{\alpha} \quad\quad\quad\quad\quad\quad(\alpha\neq1)\quad(y^{1-\alpha}=u)$$
			+ 方法：
	+ 二阶方程：判断系数
		+ 常系数：
			+ （D）二阶常系数齐次方程：
				+ 形式： $$y^n+py^{\prime}+qy=0$$
				+ 方法：写特征方程，找特征根 `->` [[Lecture 38：常系数齐次线性微分方程]]
			+ （E）二阶常系数非齐次方程： 
				+ 形式：$$y^{\prime\prime}+py^{\prime}+qy=f(x)$$
				+ 方法：将不齐次的方程，转化为两个部分，即**非齐次通解 = 齐次的通解 + 非齐次的特解**； `->` [[Lecture 39：常系数非齐次线性微分方程]]
		+ 变系数：
			+ （F）可降阶方程：有 x 有 y
				+ 形式：$$y^{\prime\prime}=f(x,y^{\prime})$$
				+ 方法：${y^{\prime}=P,y^{\prime\prime}=\frac{dP}{dx}}$，得到： $\frac{dp}{dx}=f(x,p)$ 关于 p、x 的一阶方程，然后进行分离变量
			+ （G）可降阶方程：只有 y
				+ 形式：$$y"=f(y,y^{\prime})$$
				+ 方法：设： $y^{\prime}=P$、$y^{\prime\prime}=\frac{dp}{dy}P$ `->` 变成只有 y、p，没有 x 的一阶方程，然后使用分离变量法；
+ 多元方程：
	+ （G）多元函数：
		+ 形式：
			+ 多元函数中，每个函数都被 x、或被 y 积分 $$d\bar{f}(x,y)=P(x,y)dx+Q(x,y)dy=0.$$
		+ 方法：分组凑微分  

**题型**：题型及其方法整理
+ 1. 求特解问题：
	+ （1）求通解
	+ （2）求常数
	+ （3）得到特解
+ 2. 求微分方程的反问题：知道一个特解，求微分的方程；
	+ 分析：特解 = 通解把某个条件定下来 
	+ 比如：二阶常系数非齐次方程中：通解+特解=函数 `->` $y=C_{1}y_{1}+C_{2}y_{2}+y^{\star}$
	+ 方法：先从解，找两个线性无关的解 `->` 两个特征根 `->` 齐次微分方程；  


---
### 题型： #微分方程综合题
#### PART 1：解题方法
**方法**：解微分方程综合体
+ （1）分析：是微分方程和什么内容的综合题；
+ （2）不同题型使用不同内容对应的常用方法；

#### PART 2：典型例题

#### PART 3：知识点复盘


---
### 题型： #微分方程应用题
#### PART 1：解题方法
**题型**：几何应用题 
+ 方法：  
	+ （1）画出当前图像的草图，草图需要画出主要特征；
	+ （2）利用题中给的关系式，建立微分方程； 
	+ （3）解微分方程；

#### PART 2：典型例题

#### PART 3：知识点复盘